////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Initialize(void)
{
    InitCommonControls();

    InitializeCRCTable();

    if(!GetRegistryValues())
    {
		FatalError("Error getting registry values!");
        glErrorCount++;
        return false;
    }

    if(!OpenLogFile())
    {
        FatalError("Failed to open log file");
        glErrorCount++;
        return false;
    }

    if(!InitCryptography())
    {
		FatalError("Error initializing cryptography!");
        glErrorCount++;
        return false;
    }

	if(!MyClient.Start())
    {
		FatalError("Error statting the client!");
        glErrorCount++;
        return false;
    }

    return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Uninitialize(void)
{
    UninitCryptography();

	MyClient.Stop();

    return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

